function [results] = vstar_est_ML_nu_const(y,regs1,regs2,regs3,regs4,regs5,trans,startval)
% PURPOSE: estimates a smooth transition vector autoregression ->
% system estimation without lagstructure
%---------------------------------------------------
% USAGE:  result = stvar_est(y,trans,translag,const)
% where:    y    = a (nobs x 1) vector
%           regs1 = regressors linear and nonlinear part , equation 1
%           regs2 = regressors linear and nonlinear part , equation 2
%           regs3 = regressors linear and nonlinear part , equation 3
%           regs4 = regressors linear and nonlinear part , equation 4
%           regs5 = regressors linear and nonlinear part , equation 5
%           trans = transition variable
%           startval = starting values
%
% ---------------------------------------------------
% RETURNS: a structure
%           results.meth
%---------------------------------------------------
%
% written by:
% Frauke Schleer
% schleer@zew.de

global_sv_vector

results.meth='vstar_est_ML_nu';

[nobs, neqs] = size(y);
[junk, neqs_trans] = size(trans);

param0=startval;
results.param0=param0;

if neqs_trans==2;
else
    param0=startval';
end

%Changing default options % Max Fun Evals: 100*numberOfVariables
% LargeScale algorithm requires you to provide the gradient.
%TolFun	Termination tolerance on the function value, a positive scalar. The default is 1e-6.
%TolX	Termination tolerance on x, a positive scalar. The default value is 1e-6.
% Method for choosing the search direction in the Quasi-Newton algorithm. The choices are:
%
% 'bfgs', the default
% 'dfp'
% 'steepdesc'
%A large number of Hessian updating methods have been developed. However,
%the formula of Broyden [3], Fletcher [12], Goldfarb [20], and Shanno [37] (BFGS)
%is thought to be the most effective for use in a general purpose method

%options  =  optimset('Algorithm','interior-point' ,'MaxIter',10000,'MaxFunEvals',10000,'Display','off');
[x,fval] = fmincon(@(param)STVAR_LIK(y,regs1,regs2,regs3,regs4,regs5,trans,param),param0,[],[],[],[],[],[],@(param)constraints(param,trans));

results.optval=fval;

nvar_struc=[size(regs1{1,1},2) size(regs1{1,2},2); ...
    size(regs2{1,1},2) size(regs2{1,2},2); ...
    size(regs3{1,1},2) size(regs3{1,2},2); ...
    size(regs4{1,1},2) size(regs4{1,2},2); ...
    size(regs5{1,1},2) size(regs5{1,2},2)];
nparam=numel(x)+sum(sum(nvar_struc))+const*neqs*2;
% model fit
AIC=infcr('AIC',-fval,nobs,nparam,'multi');
BIC =infcr('BIC',-fval,nobs,nparam,'multi');
HQ =infcr('HQ',-fval,nobs,nparam,'multi');

results.AIC=AIC;
results.BIC=BIC;
results.HQ=HQ;
results.loglik=-fval;
results.nvar_struc=nvar_struc;

y_sur(neqs).eq=0;
x_sur(neqs).eq=0;

% redefine gamma back 
x=[x(:,1); exp(x(:,2))];

% to get residuals

for j=1:neqs
    
    if j == 1
        regs = regs1;
    elseif j == 2
        regs = regs2;
    elseif j == 3
        regs = regs3;
    elseif j == 4
        regs = regs4;
    elseif j == 5
        regs = regs5;
    end
    
    if neqs_trans==1
        std_trans=std(trans(:,1));
        transfunc = (1+exp(-x(end)/std_trans*(trans(:,1)-x(end-1)))).^(-1); % logistic func
    else
        std_trans=std(trans(:,j));
       transfunc = (1+exp(-x(j,end)/std_trans*(trans(:,j)-x(j,end-1)))).^(-1); % logistic func
    end
    
    %Calculation of Psi
    jter=1;
    for i=1:nobs
%         Psi(jter:jter+neqs-1,:)=[diag(ones(1:neqs)) diag(ones(1:neqs)*transfunc(i,:))];
        Psi(jter:jter+neqs-1,:)=[eye(neqs) eye(neqs)*transfunc(i,:)];
%         Psi(jter:jter+neqs-1,:)=[ndSparse(speye(neqs)) ndSparse(speye(neqs)*transfunc(i,:))];
        jter=jter+neqs;
    end
    
    [junk ,im_1] = size(transfunc);
    im = im_1 + 1; % im = number of extreme states;
        
    [junk,nvar]=size(regs{:,2});
    transfunc=repmat(transfunc,[1 nvar+const]);
     
    if const==0
        g = regs{:,2}.*transfunc; %transiton function times regressors
        reg = [regs{:,1} g];
    else
        xvar=[ones(nobs,1) regs{:,2}];
        g=xvar.*transfunc;
        reg = [ones(nobs,1) regs{:,1} g];
    end
    
    y_sur(j).eq=y(:,j);
    x_sur(j).eq=reg;
    
end

%Running SURE
iflag=0;
result_sur = sur_fast_1(neqs,y_sur,x_sur, iflag); %iflag
%%%%%%%resultsur_resid=[result_sur(1,1).resid result_sur(1,2).resid];
resultsur_resid=[result_sur(1,1).resid result_sur(1,2).resid result_sur(1,3).resid result_sur(1,4).resid result_sur(1,5).resid];
%%%%%%%resultsur_beta=[result_sur(1,1).beta ;result_sur(1,2).beta];
resultsur_beta=[result_sur(1,1).beta ;result_sur(1,2).beta;result_sur(1,3).beta;result_sur(1,4).beta;result_sur(1,5).beta];
%%%%%%%resultsur_tprob=[result_sur(1,1).tprob;result_sur(1,2).tprob];
resultsur_tprob=[result_sur(1,1).tprob;result_sur(1,2).tprob;result_sur(1,3).tprob;result_sur(1,4).tprob;result_sur(1,5).tprob];
% fill results structure
results.resid= resultsur_resid;
results.beta=resultsur_beta;
results.tprob=resultsur_tprob;
results.param=x;
results.xxi=result_sur(1,1).xxi;
results.nobs=nobs;
%

%Construction of B = [B1 B2 ... Bm-1], 
% necessary for Granger Causality test and evaluation tests
B1=[];
B2=[];
[npar ,junk] = size(result_sur(1,1).beta);
for j=1:neqs
B = result_sur(1,j).beta(1:npar/2,:);
B1 = [B1, B]; 
end

for j=1:neqs
B = result_sur(1,j).beta(npar/2+1:end,:);
B2 = [B2, B]; 
end

B = [B1 B2];
results.B=B;

%------------------------------------------------------------------------
%Inference for c and gamma
%------------------------------------------------------------------------

BX = B'*xvar';
Omegainv = inv(results.resid'*results.resid);

%Construction of first derivative for Psi_t'B'x_t
j=1;
RET1=[];
for i=1:nobs
    Psit=Psi(j:j+neqs-1,:);
    Psit=Psit';
    j=j+neqs;
    
    Dpsit = Psit - Psit.*Psit;
    ms_mc = transfunc(i,1)*ones(neqs,1)-x(end-1);
    mgamma = x(end)*ones(neqs,1);
    
    Dpsit1 = Dpsit*(ms_mc);
    Dpsit2 = -Dpsit*mgamma;
    tDP=zeros(neqs,im*neqs);
    
    
    for iter=1:(im-1)
        for jter=1:neqs
            RET=[];
            %derivative w.r.t. gamma
            tDP(iter,(iter*neqs+jter)) = Dpsit1((iter*neqs+jter),iter);
            RET = [RET, (tDP*BX(:,i))'];
            tDP(iter, (iter*neqs+jter)) = 0;
            
            %derivative w.r.t. c
            tDP(iter, (iter*neqs+jter)) = Dpsit2((iter*neqs+jter),iter);
            RET = [RET, (tDP*BX(:,i))'];
            tDP(iter, (iter*neqs+jter)) = 0;
            RET1 = [RET1; RET];
        end
    end
end
derivative1 = RET1;

%Construction of second derivative for Psi_t'B'x_t
j=1;
RET1=[];
for i=1:nobs
    Psit=Psi(j:j+neqs-1,:);
    Psit=Psit';
    j=j+neqs;
    
    Dpsit = Psit - Psit.*Psit;
    ms_mc = transfunc(i,1)*ones(neqs,1)-x(end-1);
    mgamma = x(end)*ones(neqs,1);
    
    Dpsit1 = Dpsit*(ms_mc).^2.*[zeros(neqs,1);2*transfunc(i,1)*exp(-mgamma.*(ms_mc))-1];
    Dpsit2 = Dpsit*mgamma.^2.*[zeros(neqs,1);2*transfunc(i,1)*exp(-mgamma.*(ms_mc))-1];
    tDP=zeros(neqs,im*neqs);
    
    
    for iter=1:(im-1)
        for jter=1:neqs
            RET=[];
            % second derivative w.r.t. gamma
            tDP(iter,(iter*neqs+jter)) = Dpsit1((iter*neqs+jter),iter);
            RET = [RET, (tDP*BX(:,i))'];
            tDP(iter, (iter*neqs+jter)) = 0;
            
            %second derivative w.r.t. c
            tDP(iter, (iter*neqs+jter)) = Dpsit2((iter*neqs+jter),iter);
            RET = [RET, (tDP*BX(:,i))'];
            tDP(iter, (iter*neqs+jter)) = 0;
            RET1 = [RET1; RET];
        end
    end
end
derivative2 = RET1;

%construction of second derivative of loglikelihood
%%%%%%%%j=1; d2loglik=zeros(4,1);
j=1; d2loglik=zeros(10,1);
for i=1:nobs
    d2loglik = d2loglik + derivative2(j:j+neqs-1,:)'*Omegainv*resultsur_resid(i,:)'...
        - diag(derivative1(j:j+neqs-1,:)'*Omegainv*derivative1(j:j+neqs-1,:));
    j=j+neqs;
end

%calculation of empirical mean of d2loglik
Ed2loglik = d2loglik/nobs;

%calculation of standard deviation of variance for the parameters
std_param = sqrt(-Ed2loglik);

t_stat1=x(1,1)/std_param(1);
p1 = tpdf(t_stat1,nobs-nparam);
results.ttest_c=[t_stat1; p1];

t_stat2=x(2,1)/std_param(3);
p2 = tpdf(t_stat2,nobs-nparam);
results.ttest_gamma=[t_stat2; p2];

results.stderr_cgamma=[std_param(1);std_param(3)];

%--------------------------------------------------------------------------
% function for optimizing Loglikelihood in nonlinear V-STAR
%--------------------------------------------------------------------------

function [val] = STVAR_LIK(y,regs1,regs2,regs3,regs4,regs5,trans,param)
% PURPOSE: function used in optimization
%
%
% written by:
% Frauke Schleer
% schleer@zew.de
%---------------------------------------------------

global_sv_vector

[nobs, neqs]=size(y);
[junk, neqs_trans]=size(trans);

sigma=zeros(neqs,neqs);
y_sur(neqs).eq=0;
x_sur(neqs).eq=0;

for j=1:neqs
    
    if j == 1
        regs = regs1;
    elseif j == 2
        regs = regs2;
    elseif j == 3
        regs = regs3;
    elseif j == 4
        regs = regs4;
    elseif j == 5
        regs = regs5;
    end
    
    if neqs_trans==2
        std_trans=std(trans(:,j));
        transfunc = (1+exp(-exp(param(j,end))/std_trans*(trans(:,j)-param(j,end-1)))).^(-1); % logistic func
        
    else
        std_trans=std(trans(:,1));       
        transfunc = (1+exp(-exp(param(end))/std_trans*(trans(:,1)-param(end-1)))).^(-1); % logistic func
        
    end
    [junk,nvar]=size(regs{:,2});
    transfunc=repmat(transfunc,[1 nvar+const]);
    
    if const==0
        g = regs{:,2}.*transfunc; %transiton function times regressors
        reg = [regs{:,1} g];
    else
        xvar=[ones(nobs,1) regs{:,2}];
        g=xvar.*transfunc;
        reg = [ones(nobs,1) regs{:,1} g];
    end
    
    y_sur(j).eq=y(:,j);
    x_sur(j).eq=reg;
    
end

%Running SURE
iflag=0;
result_sur = sur_fast(neqs,y_sur,x_sur, iflag); %iflag

%Sigma+Loglikelihood

for i=1:neqs;
    for j=1:neqs;
        sigma(i,j) = (result_sur(1,i).resid'*result_sur(1,j).resid)/(length(result_sur(1,j).resid));
        if j > 1;
            sigma(j,i) = sigma(i,j);
        end;
    end
end

likli=-length(result_sur(1,j).resid)/2*(neqs*(1+log(2*pi))+log(det(sigma)));
val=-likli;

%---------------------------------------------------------------------
% constraints
%-------------------------------------------------------------------

function [c,ceq] = constraints(x,trans)

global_sv

c=zeros(4,1);
c(1)=log(lbtp)-x(2);
c(2)=x(2)-log(mtp);

nu_vec=(log(lbtp):incr:log(mtp))';
nu_vec=[nu_vec ;log(mtp)];
% threshold value
c_vec=linspace(0.1,1,length(nu_vec))';
c_vec=flipud(c_vec);

% transition variable
trans_sort=sort(trans);    % Sorted Values of transition variable

% [ind_0,junk]=find(trans_sort>0);
[ind_0,junk]=find(trans_sort> 0.18);
indic1=ceil(0.90*length(trans))';
if indic1(end)<ceil(ind_0(1)*1.40)
    indic=(floor(0.60*length(trans)):1:ceil(0.90*length(trans)))'; 
else
    indic=(floor(0.80*ind_0(1)):1:ceil(1.40*ind_0(1)));
end
tvar_truncated=trans_sort(indic,:); % Truncated sample: 30% of observations
trans_sort=tvar_truncated;

ind=(find(x(2)>=nu_vec));
if isempty(ind) || ind(end)==1
    tvar_truncated=trans_sort;
else
    val=(1-c_vec(ind(end)))/2;
    indic=(ceil(val*length(trans_sort)):1:ceil((1-val)*length(trans_sort)))'; %floor rounds to nearest/lowest integer
    tvar_truncated=trans_sort(indic,:);
end

c(3)=tvar_truncated(1)-x(1);
c(4)=x(1)-tvar_truncated(end);
ceq=[];

